import sys
import json

from color import colored
from update_notification_rules import update_notification_rules
from delete_wrong_handled_groups import delete_wrong_handled_groups
from manual_quota_processing import manual_quota_processing
from get_ticket_info import get_ticket_info

MODES = {
    'update_notification_rules': update_notification_rules,
    'delete_wrong_handled_groups': delete_wrong_handled_groups,
    'manual_quota_processing': manual_quota_processing,
    'get_ticket_info': get_ticket_info
}


example_quota = [
    {
        'comment': 'testing',
        'gencfg-groups': 'GROUPS',
        'hdd': 1, 'location': 'VLA',
        'memory': 1,
        'ssd': 1,
        'segment': 'default',
        'cpu': 1
    }
]


def print_help_message():
    print(colored('Avaliable modes:', attrs=['bold']))
    print(colored('    use ./db_operations mode --help for additional information', 'white'))
    print(colored('Examples:', attrs=['bold']))
    print(colored('    ./db_operations update_notification_rules', 'green'))
    print(colored('        Update notifications rules data in mongoDB from rules.json', 'white'))
    print(colored('    ./db_operations delete_wrong_handled_groups --gencfg-groups GROUPS --block-tickets TICKETS (comma-separated)', 'green'))
    print(colored('        Delete GROUPS from handled groups in mongoDB. Block TICKETS for daily script processing.', 'white'))
    print(colored('    ./db_operations manual_quota_processing --ticket TICKET --logins LOGINS. All data are comma-separated', 'green'))
    print(colored('        Read QUOTA json from stdin. Fill DB info about groups if TICKET, GROUPS and LOGINS are listed', 'white'))
    print(colored('        QUOTA example:\n {}'.format(json.dumps(example_quota, indent=4)), 'white'))
    print(colored('    ./db_operations get_ticket_info --ticket TICKET', 'green'))
    print(colored('        Print all info abouts quota from the TICKET', 'white'))


def main():
    if len(sys.argv) <= 1 or sys.argv[1] == '-h' or sys.argv[1] == '--help':
        print_help_message()
    elif sys.argv[1] in MODES:
        MODES[sys.argv[1]](sys.argv[2:])
    else:
        print('no such mode {}'.format(sys.argv[1]))
