import argparse
import json
import sys

from add_groups import add_groups


def manual_quota_processing(argv):
    def parse_args(cur_argv):
        parser = argparse.ArgumentParser(add_help=True)
        parser.add_argument('--ticket', required=False, help='Ticket with info about quota and groups')
        parser.add_argument('--logins', required=False, help='Groups owners logins')
        return parser.parse_args(cur_argv)

    args = parse_args(argv)
    json_data = json.load(sys.stdin)

    groups = []
    for el in json_data:
        groups.extend(el.get("gencfg-groups", "").replace(",", " ").split())

    groups_set = sorted(set(groups))
    if len(groups_set) < len(groups):
        sys.stderr.write("Duplicate groups found\n")  # TODO print duplicates
        exit(1)

    if not (args.ticket and groups and args.logins):
        sys.stderr("Must specify ticket, gencfg groups and logins.\n")
        exit(1)

    add_groups(ticket=args.ticket.strip('/').split('/')[-1],
                          groups=groups,
                          logins=args.logins.strip(',').split(','),
                          quota=json_data)
