import json
import pymongo
import traceback

from infra.yp_quota_distributor.lib.mongo import mongo_db


def update_notification_rules(argv):
    rules = {}
    try:
        with open('rules.json', 'r') as f:
            rules = json.load(f)
        notification_rules_collection = mongo_db["notification_rules"]
        rules = {"data": rules}
        rules.update({"_id": "rules"})
        notification_rules_collection.insert(rules)
    except pymongo.errors.DuplicateKeyError:
        notification_rules_collection.update({"_id": "rules"}, {"$set": {"data": rules["data"]}})
    except Exception:
        print(traceback.format_exc())
        return
    print("Successfully update.\nData: {}".format(rules))
