import requests
from retrying import retry
from constants import TOKEN, ABCD_API_URL


class AbcdApi(object):
    def __init__(self, abcd_api_url, token):
        self.api_url = abcd_api_url
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(token)

    def _get_request(self, path):
        return self.session.get(self.api_url + path)

    def _post_request(self, path, json_params):
        return self.session.post(self.api_url + path, json=json_params)

    @retry(stop_max_attempt_number=3)
    def get_provider_id(self, provider_name):
        response = self._get_request("/providers?limit=100")
        response.raise_for_status()

        answer = response.json()
        for provider in answer['items']:
            if provider['name'] == provider_name:
                return provider['id']
        return None

    @retry(stop_max_attempt_number=3)
    def get_default_folder_id(self, abc_service_id, folder_type="COMMON_DEFAULT_FOR_SERVICE"):
        path = "/services/{}/folders?limit=100".format(abc_service_id)
        response = self._get_request(path)
        response.raise_for_status()

        answer = response.json()
        for folder in answer['items']:
            if folder['folderType'] == folder_type:
                return folder['id']
        return None

    @retry(stop_max_attempt_number=3)
    def request_d_quota(self, data):
        response = self._post_request("/bulkQuotaMove", json_params=data)
        response.raise_for_status()
        return response


AbcdClient = AbcdApi(ABCD_API_URL, TOKEN)
