import requests
from constants import BOT_URL, TOKEN


class BotApi(object):
    def __init__(self, bot_api_url):
        self.api_url = bot_api_url
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(TOKEN)

    def get_request(self, path, params):
        res = self.session.get(self.api_url + path, params=params)
        return res


BotClient = BotApi(BOT_URL)


def get_info_about_host(name, hosttype):
    params = {
        "format": "json"
    }
    if hosttype == 'fqdn':
        params.update({"name": name})
    elif hosttype == 'inv':
        params.update({"inv": name})
    else:
        raise

    r = BotClient.get_request("api/consistof.php", params=params)
    return r.json()
