import os
import logging

HOST = os.environ.get("HOST", "https://yp-quota-distributor.n.yandex-team.ru/")
# must match URI in unified agent config
UNIFIED_AGENT_URI = os.environ.get("UNIFIED_AGENT_URI", 'unix:///tmp/yp_quota_unified_agent.sock')

ROBOT_GENCFG = 'robot-gencfg'
ROBOT_DISPENSER = 'robot-dispenser'
REMOVE_TIME_FIELD = "remove_time"

ABC_REMAPPING = 'abc_remapping'
DISPENSER_REMAPPING = 'dispenser_remapping'
GENCFG_GROUPS = 'gencfg_groups'
NANNY_SERVICES = 'nanny_services'
QLOUD_PROJECTS = 'qloud_projects'
TOKEN = os.environ.get("TOKEN", "")
GROUP_REGEXP = "(?=.*[A-Z].*)(MSK|SAS|VLA|MAN|IVA|MYT|ALL)_[A-Z0-9][A-Z0-9_]+[A-Z0-9]"

ABC_URL = os.environ.get("ABC_URL", "https://abc.yandex-team.ru")
ABC_API_HOST = os.environ.get("ABC_URL", "https://abc-back.yandex-team.ru")
ABC_API_URL = os.environ.get("ABC_API_URL", "https://abc-back.yandex-team.ru/api/v4")
ABCD_API_URL = os.environ.get("ABCD_API_URL", "https://d-api.yandex-team.ru/api/v1")

DISPENSER_URL = os.environ.get('DISPENSER_URL', 'https://dispenser-test.yandex-team.ru/')
GENCFG_API_URL = os.environ.get("GENCFG_API_URL", "https://api.gencfg.yandex-team.ru")
NANNY_URL = os.environ.get("NANNY_URL", "http://nanny.yandex-team.ru")
BOT_URL = os.environ.get("BOT_URL", "https://bot.yandex-team.ru/")

QLOUD_API_URL = os.environ.get("QLOUD_API_URL", "https://qloud.yandex-team.ru/api/v1/")
QLOUD_EXT_API_URL = os.environ.get("QLOUD_EXT_API_URL", "https://qloud-ext.yandex-team.ru/api/v1/")

STARTREK_URL = os.environ.get("STARTREK_URL", "https://st.yandex-team.ru/")
STARTREK_API_BASE_URL = os.environ.get("STARTREK_API_BASE_URL", "https://st-api.yandex-team.ru/")

GROUP_SHORT_CARD_TEMPLATE = GENCFG_API_URL + "/trunk/groups/{}"
GROUP_FULL_CARD_TEMPLATE = GENCFG_API_URL + "/trunk/groups/{}/card"

NOTIFICATION_TEXT_TEMPLATE = "\n".join([
    "Квота в счёт групп {groups} была получена уже {days} дней назад.",
    "Кажется этого достаточно чтобы перевести сервис в YP.",
    "Если вы уже перевели сервис, пожалуйста, удалите старые группы.",
    "Иначе напишите, что вам мешает завершить перевод сервиса и когда вы его закончите."
])

NOTIFICATION_BEFORE_DELETING_TEXT_TEMPLATE = "\n".join([
    "Так как квота для переезда указанных ниже групп в YP была получена {days} дней назад и группы в настоящий момент не используются через неделю {date} эти группы будут удалены.",
    "Если есть причины почему это нельзя делать, пожалуйста, скажите сейчас.",
    "Список групп: {groups}"
])

ERROR_STATUS_API_WITHOUT_REQUEST_ID = "Please add corresponding record_id query parameter to the url or reload the page"

GROUPS_WERE_REMOVED_NOTIFICATION_TEMPLATE = "Следующие группы были удалены: {groups}"

VALID_MASTER_GROUPS = [
    "ALL_DYNAMIC",
    "ALL_PERSONAL",
    "ALL_SOX"
]

SEGMENTS_CHOICES = [("default", "default"), ("dev", "dev"),
                    ("base-search", "base-search"),
                    ("base-search-cohabitation", "base-search-cohabitation"),
                    ("yt_hahn", "yt_hahn"), ("yt_freud", "yt_freud"),
                    ("yt_hume", "yt_hume"), ("yt_vanga", "yt_vanga"),
                    ("yt_kelvin", "yt_kelvin"), ("yt_arnold", "yt_arnold"),
                    ("sre-test", "sre-test"), ("lvm-test", "lvm-test")]
DC_CHOICES = [("SAS", "SAS"), ("MAN", "MAN"), ("VLA", "VLA"), ("IVA", "IVA"),
              ("MYT", "MYT"), ("MAN-PRE", "MAN-PRE"), ("SAS_TEST", "SAS_TEST")]

# NOTE: if you change LOG_FORMAT, change parse rules accordingly https://a.yandex-team.ru/arc/trunk/arcadia/logfeller/configs/parsers/yp-quota-distributor-log.yaml
# NOTE: if you change LOG_DATEFTM, change parser timestamp format accordingly https://a.yandex-team.ru/arc/trunk/arcadia/logfeller/configs/parsers/parsers.auto.json?rev=7278045#L46549
LOG_FORMAT = '%(asctime)s\t%(levelname)s\t%(name)s\t%(message)s'
LOG_DATEFTM = '%Y-%m-%d %H:%M:%S'
LOG_FORMATTER = logging.Formatter(LOG_FORMAT, LOG_DATEFTM)

ERROR_INFO = "Error while request processing"
MONGO_DB_KEY = os.environ.get("MONGO_DB_KEY", "yp_quota_distributor_base")

ABC_RESOURCES_TEMPLATE = "/services/{}/folders"
ADMINS = ["atridis", "glebskvortsov"]
