import logging

from infra.yp_quota_distributor.lib.constants import (
    LOG_FORMATTER,
    UNIFIED_AGENT_URI
)

from logbroker.unified_agent.client.python import UnifiedAgentHandler


class CustomUnifiedAgentHandler(UnifiedAgentHandler):
    # nedeed to make all messages one-liners for logfeller https://wiki.yandex-team.ru/logfeller/parser/formats/#pozicionnyjjformat
    def __init__(self, URI):
        super(CustomUnifiedAgentHandler, self).__init__(URI)

    def emit(self, record):
        message = '\\n'.join(record.msg.split('\n'))
        record.msg = message
        super(CustomUnifiedAgentHandler, self).emit(record)


def get_unified_agent_handler():
    log_handler = CustomUnifiedAgentHandler(UNIFIED_AGENT_URI)
    log_handler.setFormatter(LOG_FORMATTER)
    log_handler.setLevel(logging.DEBUG)
    return log_handler


def get_file_handler():
    log_handler = logging.FileHandler('FileLogger.out')
    log_handler.setFormatter(LOG_FORMATTER)
    log_handler.setLevel(logging.DEBUG)
    return log_handler
