import requests
from constants import (
    NANNY_URL,
    TOKEN
)


class NannyApi(object):
    def __init__(self, nanny_api_url, token):
        self.api_url = nanny_api_url
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(token)

    def post_request(self, path, data):
        return self.session.post(self.api_url + path, json=data)

    def get_request(self, path):
        return self.session.get(self.api_url + path)


NannyClient = NannyApi(NANNY_URL, TOKEN)


def get_services_for_gencfg_group(group):
    r = NannyClient.post_request("/api/repo/GetServicesForGencfgGroup/", {"groupName": group})
    services = []
    if r.ok:
        for service in r.json().get("serviceRefs", []):
            services.append(service["id"])
    return services


def is_service_active(service):
    r = NannyClient.get_request("/v2/services/{}/active/runtime_attrs/".format(service))
    if r.ok:
        active_runtime_data = r.json()
        return "content" in active_runtime_data
    else:
        return True
