import requests
#  from retrying import retry
from constants import (
    QLOUD_API_URL,
    QLOUD_EXT_API_URL
)
import urllib3


class QloudApi(object):
    def __init__(self, qloud_url, token):
        self.api_url = ""
        host = urllib3.util.parse_url(qloud_url).host
        if host in QLOUD_API_URL:
            self.api_url = QLOUD_API_URL
        elif host in QLOUD_EXT_API_URL:
            self.api_url = QLOUD_EXT_API_URL
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(token)

    def _get_request(self, path, cgi_params=None):
        if cgi_params is None:
            cgi_params = {}
        return self.session.get(self.api_url + path, params=cgi_params)

    def _post_request(self, path, cgi_params=None):
        if cgi_params is None:
            cgi_params = {}
        return self.session.post(self.api_url + path, params=cgi_params, allow_redirects=False)

    def get_all_projects(self):
        return self._get_request('project')

    def get_quota_for_project(self, project_key):
        return self._get_request('project/{}/quota'.format(project_key))

    def get_project_access_info(self, project_key):
        return self._get_request('access/{}'.format(project_key))

    def decrease_quota(self, project, dc, segment, resource, value):
        return self._post_request('admin/project/quota/decrease/{}'.format(project), cgi_params={
            "location": dc,
            "hardwareSegment": segment,
            "resource": resource,
            "quotaToDecrease": value
        })

    def increase_quota(self, project, dc, segment, resource, value):
        return self._post_request('admin/project/quota/increase/{}'.format(project), cgi_params={
            "location": dc,
            "hardwareSegment": segment,
            "resource": resource,
            "quotaToIncrease": value
        })
