import walle_api
from constants import TOKEN


Client = walle_api.WalleClient(url=walle_api.constants.PRODUCTION_URL, access_token=TOKEN)


def get_scenario(scenario_id, fields=None):
    if fields is None:
        fields = ['status']
    return Client.get_scenario(scenario_id, fields=fields)


def get_hosts(names=None, invs=None, limit=10000, fields=None):
    if names is None:
        names = []
    if invs is None:
        invs = []
    if fields is None:
        fields = ['inv', 'name', 'project', 'location.short_datacenter_name']
    return Client.get_hosts(names=names, invs=invs, limit=limit, fields=fields)


def get_audit_log(host_inv, event_type=None, fields=None):
    return Client._get_audit_log(host_inv=host_inv, event_type=event_type, fields=fields)


def find_hosts_new_inv(inv):
    audit_log = get_audit_log(inv, event_type='host-inv-changed', fields=['decision', 'payload'])
    for log_line in audit_log['result']:
        old_inv = log_line['payload'].get('old_inv')
        new_inv = log_line['payload'].get('new_inv')
        if old_inv == inv:
            return new_inv
    return None


def create_add_hosts_rtc_scenario(name, ticket_key, hosts, target_project_id, responsible, ticket_created_by='robot-gencfg', autostart=False):
    return Client.create_add_hosts_rtc_scenario(
        name=name,
        ticket_key=ticket_key,
        hosts=hosts,
        responsible=responsible,
        target_project_id=target_project_id,
        ticket_created_by=ticket_created_by,
        autostart=autostart
    )


def cancel_scenario(scenario_id):
    return Client.cancel_scenario(scenario_id, 'Error occured')
