#include <infra/yp_service_discovery/libs/client/client.h>
#include <infra/yp_service_discovery/libs/main/main.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/small/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char** argv) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       NYP::NServiceDiscovery::RunMain,
                       "Run yp_service_discovery daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Print yp_service_discovery eventlog.");

    modChooser.AddMode("client",
                       NYP::NServiceDiscovery::RunClient,
                       "Run yp_service_discovery client.");
    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
