package cachedresolver

import "a.yandex-team.ru/library/go/core/log"

type ResolverOpt func(*CachedResolver)

// ReturnStaleCache allows to use expired cache in case of resolving error.
func ReturnStaleCache(returnStale bool) ResolverOpt {
	return func(r *CachedResolver) {
		r.returnStale = returnStale
	}
}

// WithLogger sets logger to cached resolver.
func WithLogger(l log.Structured) ResolverOpt {
	return func(r *CachedResolver) {
		r.logger = l
	}
}
