package cachedresolver

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func TestReturnStaleCache(t *testing.T) {
	cr := new(CachedResolver)
	ReturnStaleCache(true)(cr)
	assert.True(t, cr.returnStale)
}

func TestWithLogger(t *testing.T) {
	logger := zap.Must(zap.CLIConfig(log.DebugLevel))
	cr := new(CachedResolver)
	WithLogger(logger)(cr)
	assert.Same(t, logger, cr.logger)
}
