package grpcresolver_test

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver/grpcresolver"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func ExampleNew() {
	logger := zap.Must(zap.CLIConfig(log.DebugLevel))

	r, err := grpcresolver.New(
		grpcresolver.WithClientName("volozh"),
		grpcresolver.WithLogger(logger),
		grpcresolver.WithServiceURI(resolver.ServiceDiscoveryBalancerSAS),
	)

	if err != nil {
		panic(err)
	}

	defer r.Close()
}

func ExampleResolver_ResolveEndpoints() {
	r, _ := grpcresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolveEndpoints(ctx, "sas", "chaos-service")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}

func ExampleResolver_ResolvePods() {
	r, _ := grpcresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolvePods(ctx, resolver.ClusterSAS, "chaos-service")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}

func ExampleResolver_ResolveNode() {
	r, _ := grpcresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolveNode(ctx, resolver.ClusterSAS, "1c-01-sas.lxc.lavka.yandex.net")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}
