package grpcresolver

import (
	"google.golang.org/grpc"

	pb "a.yandex-team.ru/infra/yp_service_discovery/api"
	"a.yandex-team.ru/library/go/core/log"
)

type ResolverOpt func(*Resolver)

func WithServiceURI(uri string) ResolverOpt {
	return func(r *Resolver) {
		r.serviceURI = uri
	}
}

func WithClientName(name string) ResolverOpt {
	return func(r *Resolver) {
		r.clientName = name
	}
}

func WithLogger(l log.Structured) ResolverOpt {
	return func(r *Resolver) {
		r.logger = l
	}
}

func WithResolveEndpointsRUIDFunc(f ResolveEndpointsRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolveEndpointsRUIDFunc = f
	}
}

func WithResolvePodsRUIDFunc(f ResolvePodsRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolvePodsRUIDFunc = f
	}
}

func WithResolveNodeRUIDFunc(f ResolveNodeRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolveNodeRUIDFunc = f
	}
}

func WithGRPCClient(client pb.TServiceDiscoveryServiceClient, conn *grpc.ClientConn) ResolverOpt {
	return func(r *Resolver) {
		r.grpcConn = conn
		r.grpcClient = client
	}
}

func WithGRPCConn(conn *grpc.ClientConn) ResolverOpt {
	return func(r *Resolver) {
		r.grpcConn = conn
		r.grpcClient = pb.NewTServiceDiscoveryServiceClient(conn)
	}
}
