package httpresolver_test

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver/httpresolver"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func ExampleNew() {
	logger := zap.Must(zap.CLIConfig(log.DebugLevel))

	serviceURI := "http://" + resolver.ServiceDiscoveryBalancerSAS + ":" + resolver.ServiceDiscoveryHTTPPort
	r, err := httpresolver.New(
		httpresolver.WithClientName("volozh"),
		httpresolver.WithLogger(logger),
		httpresolver.WithServiceURI(serviceURI),
	)

	if err != nil {
		panic(err)
	}

	defer r.Close()
}

func ExampleResolver_ResolveEndpoints() {
	r, _ := httpresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolveEndpoints(ctx, "sas", "chaos-service")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}

func ExampleResolver_ResolvePods() {
	r, _ := httpresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolvePods(ctx, resolver.ClusterSAS, "chaos-service")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}

func ExampleResolver_ResolveNode() {
	r, _ := httpresolver.New()

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancel()

	resp, err := r.ResolveNode(ctx, resolver.ClusterSAS, "1c-01-sas.lxc.lavka.yandex.net")
	if err != nil {
		panic(err)
	}

	fmt.Println(resp.ResolveStatus)
}
