package httpresolver

import (
	"a.yandex-team.ru/library/go/core/log"
	"github.com/go-resty/resty/v2"
)

type ResolverOpt func(*Resolver)

func WithServiceURI(uri string) ResolverOpt {
	return func(r *Resolver) {
		r.serviceURI = uri
	}
}

func WithClientName(name string) ResolverOpt {
	return func(r *Resolver) {
		r.clientName = name
	}
}

func WithLogger(l log.Structured) ResolverOpt {
	return func(r *Resolver) {
		r.logger = l
	}
}

func WithResolveEndpointsRUIDFunc(f ResolveEndpointsRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolveEndpointsRUIDFunc = f
	}
}

func WithResolvePodsRUIDFunc(f ResolvePodsRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolvePodsRUIDFunc = f
	}
}

func WithResolveNodeRUIDFunc(f ResolveNodeRUIDFunc) ResolverOpt {
	return func(r *Resolver) {
		r.resolveNodeRUIDFunc = f
	}
}

func WithCustomHTTPClient(client *resty.Client) ResolverOpt {
	return func(r *Resolver) {
		r.httpc = client
	}
}
