package httpresolver

import (
	"fmt"
	"testing"

	"github.com/go-resty/resty/v2"
	"github.com/stretchr/testify/assert"

	pb "a.yandex-team.ru/infra/yp_service_discovery/api"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func TestWithClientName(t *testing.T) {
	clientName := "volozh"
	r := new(Resolver)
	WithClientName(clientName)(r)
	assert.Equal(t, clientName, r.clientName)
}

func TestWithLogger(t *testing.T) {
	logger := zap.Must(zap.CLIConfig(log.FatalLevel))
	r := new(Resolver)
	WithLogger(logger)(r)
	assert.Same(t, logger, r.logger)
}

func TestWithServiceURI(t *testing.T) {
	serviceURI := "sd-test.yandex.net"
	r := new(Resolver)
	WithServiceURI(serviceURI)(r)
	assert.Equal(t, serviceURI, r.serviceURI)
}

func TestWithResolveEndpointsRUIDFunc(t *testing.T) {
	fn := func(_ *pb.TReqResolveEndpoints) string {
		return "ololo"
	}
	r := new(Resolver)
	WithResolveEndpointsRUIDFunc(fn)(r)
	assert.Equal(t, fmt.Sprintf("%p", fn), fmt.Sprintf("%p", r.resolveEndpointsRUIDFunc))
}

func TestWithResolvePodsRUIDFunc(t *testing.T) {
	fn := func(_ *pb.TReqResolvePods) string {
		return "ololo"
	}
	r := new(Resolver)
	WithResolvePodsRUIDFunc(fn)(r)
	assert.Equal(t, fmt.Sprintf("%p", fn), fmt.Sprintf("%p", r.resolvePodsRUIDFunc))
}

func TestWithResolveNodeRUIDFunc(t *testing.T) {
	fn := func(_ *pb.TReqResolveNode) string {
		return "ololo"
	}
	r := new(Resolver)
	WithResolveNodeRUIDFunc(fn)(r)
	assert.Equal(t, fmt.Sprintf("%p", fn), fmt.Sprintf("%p", r.resolveNodeRUIDFunc))
}

func TestWithCustomHTTPClient(t *testing.T) {
	client := resty.New().
		SetRetryCount(5).
		SetRetryWaitTime(1).
		SetRetryMaxWaitTime(10)
	r := new(Resolver)
	WithCustomHTTPClient(client)(r)
	assert.Equal(t, client, r.httpc)
}
