package mockresolver

import (
	"context"
	"io"

	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
)

var _ io.Closer = new(Resolver)
var _ resolver.Resolver = new(Resolver)

type Resolver struct {
	MockResolveEndpoints func(ctx context.Context, cluster, endpointSet string) (*resolver.ResolveEndpointsResponse, error)
	MockResolveNode      func(ctx context.Context, cluster, nodeID string) (*resolver.ResolveNodeResponse, error)
	MockResolvePods      func(ctx context.Context, cluster, podSet string) (*resolver.ResolvePodsResponse, error)
	MockClose            func() error
}

func (r Resolver) ResolveEndpoints(ctx context.Context, cluster, endpointSet string) (*resolver.ResolveEndpointsResponse, error) {
	if r.MockResolveEndpoints == nil {
		return nil, nil
	}
	return r.MockResolveEndpoints(ctx, cluster, endpointSet)
}

func (r Resolver) ResolveNode(ctx context.Context, cluster, nodeID string) (*resolver.ResolveNodeResponse, error) {
	if r.MockResolveNode == nil {
		return nil, nil
	}
	return r.MockResolveNode(ctx, cluster, nodeID)
}

func (r Resolver) ResolvePods(ctx context.Context, cluster, podSet string) (*resolver.ResolvePodsResponse, error) {
	if r.MockResolvePods == nil {
		return nil, nil
	}
	return r.MockResolvePods(ctx, cluster, podSet)
}

func (r Resolver) Close() error {
	if r.MockClose == nil {
		return nil
	}
	return r.MockClose()
}
