package resolver

import (
	"context"
	"io"
)

const (
	ServiceDiscoveryHostProd = "sd.yandex.net"
	ServiceDiscoveryGRPCPort = "8081"
	ServiceDiscoveryHTTPPort = "8080"

	ClusterMAN = "man"
	ClusterSAS = "sas"
	ClusterVLA = "vla"
	ClusterIVA = "iva"
	ClusterMYT = "myt"

	ServiceDiscoveryBalancerSAS = ClusterSAS + "." + ServiceDiscoveryHostProd
	ServiceDiscoveryBalancerMAN = ClusterMAN + "." + ServiceDiscoveryHostProd
	ServiceDiscoveryBalancerVLA = ClusterVLA + "." + ServiceDiscoveryHostProd
	ServiceDiscoveryBalancerMSK = "msk." + ServiceDiscoveryHostProd
)

var AvailableClusters = []string{
	ClusterMAN,
	ClusterSAS,
	ClusterVLA,
	ClusterIVA,
	ClusterMYT,
}

// Resolver represents YS Service Discovery resolver client.
type Resolver interface {
	io.Closer

	ResolveEndpoints(ctx context.Context, cluster, endpointSet string) (*ResolveEndpointsResponse, error)
	ResolvePods(ctx context.Context, cluster, podSet string) (*ResolvePodsResponse, error)
	ResolveNode(ctx context.Context, cluster, node string) (*ResolveNodeResponse, error)
}
