package grpcresolver

import (
	"google.golang.org/grpc/resolver"
)

type attrKey string

var attrClusterKey = attrKey("cluster")

func AddressCluster(address resolver.Address) string {
	cluster := address.Attributes.Value(attrClusterKey)
	if cluster == nil {
		return ""
	}

	return cluster.(string)
}

var attrIDKey = attrKey("id")

func AddressID(address resolver.Address) string {
	id := address.Attributes.Value(attrIDKey)
	if id == nil {
		return ""
	}

	return id.(string)
}

var attrLabelsKey = attrKey("labels")

func AddressLabels(address resolver.Address) []string {
	labels := address.Attributes.Value(attrLabelsKey)
	if labels == nil {
		return nil
	}

	return labels.(labelsSlice)
}

type labelsSlice []string

func (l labelsSlice) Equal(o interface{}) bool {
	otherLabels, ok := o.(labelsSlice)
	if !ok {
		return false
	}

	if len(l) != len(otherLabels) {
		return false
	}

	// labels are already sorted while initialization
	for i, ol := range otherLabels {
		if l[i] != ol {
			return false
		}
	}

	return true
}
