package grpcresolver_test

import (
	"time"

	grpcZap "github.com/grpc-ecosystem/go-grpc-middleware/logging/zap"
	"google.golang.org/grpc"

	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
	"a.yandex-team.ru/infra/yp_service_discovery/golang/wrapper/grpcresolver"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func Example_simple() {
	// setup gRPC logger
	zlog, err := zap.New(zap.ConsoleConfig(log.WarnLevel))
	if err != nil {
		panic(err)
	}

	grpcZap.ReplaceGrpcLoggerV2(zlog.L)

	// Generate gRPC target that points to ouer resolver scheme
	// in this case we use endpoint set "endpointset_id" in SAS and MAN
	target := grpcresolver.GrpcTarget("endpointset_id", resolver.ClusterSAS, resolver.ClusterMAN)

	// next, use it in gRPC connection
	cc, err := grpc.Dial(target)
	if err != nil {
		panic(err)
	}

	// do smth useful

	_ = cc.Close()
}

func Example_customResolver() {
	// create custom grpcresolver builder
	r := grpcresolver.NewBuilder(grpcresolver.WithRefreshFrequency(30 * time.Second))
	defer func() { _ = r.Close() }()

	// generate gRPC target
	// in this case we use endpoint set "endpointset_id" in SAS
	target := grpcresolver.GrpcTarget("endpointset_id", resolver.ClusterSAS)

	// and use our target with our resolver
	cc, err := grpc.Dial(target, grpc.WithResolvers(r))
	if err != nil {
		panic(err)
	}

	// do smth useful

	_ = cc.Close()
}

func Example_customTargetParams() {
	// generate gRPC target with refresh frequency - 5s
	target := grpcresolver.NewTargetBuilder("endpointset_id", resolver.ClusterSAS).
		WithRefreshFrequency(5 * time.Second).
		Build()

	// use it
	cc, err := grpc.Dial(target)
	if err != nil {
		panic(err)
	}

	// do smth useful

	_ = cc.Close()
}
