package grpcresolver

import (
	"time"

	ypResolver "a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
)

type BuilderOption func(builder *Builder)

// WithRefreshFrequency sets resolution frequency.
//
// Default: 1 minute
func WithRefreshFrequency(freq time.Duration) BuilderOption {
	return func(builder *Builder) {
		builder.t.freq = freq
	}
}

// WithResolverTimeout sets timeout for each request to YP.SD.
//
// Default: 1 second
func WithResolverTimeout(timeout time.Duration) BuilderOption {
	return func(builder *Builder) {
		builder.t.timeout = timeout
	}
}

// WithReResolutionRate sets re-resolution rate limits (i.e. how often we can request YP SD).
// This prevents excessive re-resolution and allow to configure exponential backoff re-resolution in case of trouble.
//
// Default: 5 seconds
func WithReResolutionRate(rate time.Duration) BuilderOption {
	return func(builder *Builder) {
		builder.t.resRate = rate
	}
}

// WithYpResolver sets custom YP SD resolver.
func WithYpResolver(r ypResolver.Resolver) BuilderOption {
	return func(builder *Builder) {
		builder.resolver = r
	}
}

// WithAllowEmptyAddressList allows resolver to retrun empty adress list from YP SD request,
// which can be returned, in some cases (see README.md)
//
// Default: false
func WithAllowEmptyAddressList() BuilderOption {
	return func(builder *Builder) {
		builder.t.allowEmpty = true
	}
}
