package ru.yandex.yp.discovery;

import java.util.concurrent.TimeUnit;

import io.grpc.ConnectivityState;

/**
 * YP service discovery client, thin wrapper around actual API methods
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YpDiscoveryClient {

    /**
     * Return channel state
     *
     * @param requestConnection if {@code true}, the channel will try to make a connection if it is currently IDLE
     * @return Channel state
     */
    ConnectivityState getChannelState(boolean requestConnection);

    /**
     * Initiates an orderly shutdown in which preexisting calls continue but new calls are immediately cancelled.
     *
     * @param timeout Shutdown timeout.
     * @param timeUnit Shutdown timeout time unit.
     * @return Is shutdown successful?
     */
    boolean shutdown(long timeout, TimeUnit timeUnit);

    /**
     * Initiates a forceful shutdown in which preexisting and new calls are cancelled.
     *
     * @param timeout Shutdown timeout.
     * @param timeUnit Shutdown timeout time unit.
     * @return Is shutdown successful?
     */
    boolean shutdownNow(long timeout, TimeUnit timeUnit);

    /**
     * Return service discovery service implementation.
     *
     * @return Service discovery service implementation.
     */
    YpDiscoveryService serviceDiscoveryService();

}
