package ru.yandex.yp.discovery;

import java.time.Duration;

/**
 * YP service discovery client monitoring listener
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YpDiscoveryClientMonitoring {

    /**
     * On request started callback
     * @param type Request type
     */
    void onRequestStarted(YpDiscoveryRequestType type);

    /**
     * On request finished callback
     * @param type Request type
     * @param duration Request duration
     * @param success Is request successful?
     */
    void onRequestFinished(YpDiscoveryRequestType type, Duration duration, boolean success);

}
