package ru.yandex.yp.discovery;

import java.util.Objects;

/**
 * YP service discovery instance to connect to.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YpDiscoveryInstance {

    /**
     * Cross DC production SLB.
     */
    public static final YpDiscoveryInstance CROSS_DC = new YpDiscoveryInstance("sd.yandex.net", 8081);
    /**
     * SAS production SLB.
     */
    public static final YpDiscoveryInstance SAS = new YpDiscoveryInstance("sas.sd.yandex.net", 8081);
    /**
     * MAN production SLB.
     */
    public static final YpDiscoveryInstance MAN = new YpDiscoveryInstance("man.sd.yandex.net", 8081);
    /**
     * VLA production SLB.
     */
    public static final YpDiscoveryInstance VLA = new YpDiscoveryInstance("vla.sd.yandex.net", 8081);
    /**
     * MSK production SLB.
     */
    public static final YpDiscoveryInstance MSK = new YpDiscoveryInstance("msk.sd.yandex.net", 8081);

    private final String host;
    private final int port;

    /**
     * Create YP instance.
     * @param host Host FQDN.
     * @param port Port number.
     */
    public YpDiscoveryInstance(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        this.host = host;
        this.port = port;
    }

    /**
     * Return host FQDN.
     *
     * @return Host FQDN.
     */
    public String getHost() {
        return host;
    }

    /**
     * Return port number.
     *
     * @return Port number.
     */
    public int getPort() {
        return port;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YpDiscoveryInstance that = (YpDiscoveryInstance) o;
        return port == that.port
                && Objects.equals(host, that.host);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, port);
    }

    @Override
    public String toString() {
        return "YpDiscoveryInstance{"
                + "host='" + host + '\''
                + ", port=" + port
                + '}';
    }

}
