package ru.yandex.yp.discovery;

import java.util.concurrent.CompletableFuture;

import ru.yandex.yp.discovery.model.EndpointsResolveRequest;
import ru.yandex.yp.discovery.model.EndpointsResolveResponse;

/**
 * YP service discovery service interface.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface YpDiscoveryService {

    /**
     * Resolve YP endpoints.
     *
     * @param request Resolve request.
     * @return {@link CompletableFuture} with resolve response.
     */
    CompletableFuture<EndpointsResolveResponse> resolveEndpoints(EndpointsResolveRequest request);

}
