package ru.yandex.yp.discovery;

import com.google.protobuf.ByteString;

/**
 * YP error attributes deserializer
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@FunctionalInterface
public interface YpErrorAttributeDeserializer<T> {

    /**
     * Deserialize error attribute
     * @param key Attribute key
     * @param value Attribute value
     * @return Deserialized attribute value
     */
    T deserialize(String key, ByteString value);

}
