package ru.yandex.yp.discovery.impl;

import java.util.concurrent.Executor;

import io.grpc.CallCredentials;
import io.grpc.Metadata;

import ru.yandex.yp.discovery.YpCredentialsProvider;

/**
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class YpCallCredentials extends CallCredentials {

    private static final Metadata.Key<String> YT_TOKEN
            = Metadata.Key.of("yt-token", Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> YT_AUTH_TOKEN
            = Metadata.Key.of("yt-auth-token", Metadata.ASCII_STRING_MARSHALLER);

    private final YpCredentialsProvider credentialsProvider;

    public YpCallCredentials(YpCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void applyRequestMetadata(RequestInfo requestInfo, Executor appExecutor, MetadataApplier applier)
    {
        String token = credentialsProvider.getToken();
        Metadata headers = new Metadata();
        headers.put(YT_TOKEN, token);
        headers.put(YT_AUTH_TOKEN, token);
        applier.apply(headers);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

}
