package ru.yandex.yp.discovery.impl;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

/**
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class YpRequestIdInterceptor implements ClientInterceptor {

    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final Metadata.Key<String> YT_REQUEST_ID =
            Metadata.Key.of("yt-request-id", Metadata.ASCII_STRING_MARSHALLER);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method,
            CallOptions callOptions, Channel next)
    {
        String uuid = guid();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)) {
            @Override
            public void start(Listener<RespT> responseListener, Metadata headers) {
                headers.put(YT_REQUEST_ID, uuid);
                super.start(responseListener, headers);
            }
        };
    }

    private String guid() {
        Random random = ThreadLocalRandom.current();
        long first = random.nextLong();
        long second = ((long) COUNTER.incrementAndGet() << 32) | (random.nextInt() & 0xffffffffL);
        return Integer.toUnsignedString((int) (second >>> 32), 16)
                + '-' + Integer.toUnsignedString((int) second, 16)
                + '-' + Integer.toUnsignedString((int) (first >>> 32), 16)
                + '-' + Integer.toUnsignedString((int) first, 16);
    }

}
