package ru.yandex.yp.discovery.model;

import NYP.NServiceDiscovery.NApi.Api;

/**
 * YP endpoint resolve status.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public enum YpEndpointResolveStatus {

    /**
     * Not exists.
     */
    NOT_EXISTS(Api.EResolveStatus.NOT_EXISTS),
    /**
     * Not changed.
     */
    @Deprecated
    NOT_CHANGED(Api.EResolveStatus.NOT_CHANGED),
    /**
     * Ok.
     */
    OK(Api.EResolveStatus.OK),
    /**
     * Empty.
     */
    EMPTY(Api.EResolveStatus.EMPTY),
    ;

    private final Api.EResolveStatus status;

    YpEndpointResolveStatus(Api.EResolveStatus status) {
        this.status = status;
    }

    /**
     * Return GRPC definition
     * @return GRPC definition
     */
    public Api.EResolveStatus getStatus() {
        return status;
    }

    /**
     * Convert from GRPC definition.
     *
     * @param status GRPC definition.
     * @return YP endpoint resolve status.
     */
    public static YpEndpointResolveStatus from(Api.EResolveStatus status) {
        switch (status) {
            case NOT_EXISTS:
                return YpEndpointResolveStatus.NOT_EXISTS;
            case NOT_CHANGED:
                return YpEndpointResolveStatus.NOT_CHANGED;
            case OK:
                return YpEndpointResolveStatus.OK;
            case EMPTY:
                return YpEndpointResolveStatus.EMPTY;
            default:
                throw new IllegalArgumentException("Unsupported YP endpoint resolve status " + status);
        }
    }

}
