package ru.yandex.yp.discovery.model;

import java.util.List;
import java.util.Objects;

/**
 * YP endpoint set.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YpEndpointSet {

    private final String id;
    private final List<YpEndpoint> endpoints;

    /**
     * Create YP endpoint set.
     *
     * @param id YP endpoint set id.
     * @param endpoints YP endpoints.
     */
    public YpEndpointSet(String id, List<YpEndpoint> endpoints) {
        this.id = id;
        this.endpoints = endpoints;
    }

    /**
     * Return YP endpoint set id.
     *
     * @return YP endpoint set id.
     */
    public String getId() {
        return id;
    }

    /**
     * Return YP endpoints.
     *
     * @return YP endpoints.
     */
    public List<YpEndpoint> getEndpoints() {
        return endpoints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YpEndpointSet that = (YpEndpointSet) o;
        return Objects.equals(id, that.id)
                && Objects.equals(endpoints, that.endpoints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, endpoints);
    }

    @Override
    public String toString() {
        return "YpEndpointSet{"
                + "id='" + id + '\''
                + ", endpoints=" + endpoints
                + '}';
    }

}
