package ru.yandex.yp.discovery.model;

import io.grpc.StatusRuntimeException;

/**
 * Exception thrown when YP returns extra error description
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class YpException extends RuntimeException {

    private final YpError ypError;
    private final String description;

    /**
     * Create YP exception
     * @param message Error message
     * @param description Error description
     * @param ypError YP error metadata
     * @param cause Error cause
     */
    public YpException(String message, String description, YpError ypError, StatusRuntimeException cause) {
        super(message, cause);
        this.description = description;
        this.ypError = ypError;
    }

    /**
     * Return error description
     * @return Error description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Return YP error metadata
     * @return YP error metadata
     */
    public YpError getYpError() {
        return ypError;
    }

}
