package ru.yandex.yp.discovery;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.yp.discovery.model.EndpointsResolveRequest;
import ru.yandex.yp.discovery.model.EndpointsResolveResponse;

/**
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@RunWith(JUnit4.class)
@Ignore
public class ResolveEndpointsTest {

    private static final Logger logger = LoggerFactory.getLogger(ResolveEndpointsTest.class);

    private static final String DEFAULT_CLIENT_NAME = "Java YP discovery client test";
    private static final String CLUSTER_NAME = "sas";
    private static final String ENDPOINT_SET_ID = "";

    @Test
    public void testResolveEndpoints() throws ExecutionException, InterruptedException {
        YpDiscoveryClient client = new YpDiscoveryClientBuilder(YpDiscoveryInstance.CROSS_DC, DEFAULT_CLIENT_NAME).build();
        try {
            EndpointsResolveRequest request = EndpointsResolveRequest.builder(CLUSTER_NAME, ENDPOINT_SET_ID).build();
            EndpointsResolveResponse result = client.serviceDiscoveryService().resolveEndpoints(request).get();
            logger.info("Resolved endpoints: {}", result);
        } finally {
            if (!client.shutdown(1, TimeUnit.SECONDS)) {
                client.shutdownNow(100, TimeUnit.MILLISECONDS);
            }
        }
    }

}
