#include "client.h"

#include <infra/yp_service_discovery/libs/router_api/router_api.h>

#include <library/cpp/getopt/small/last_getopt.h>

namespace NYP::NServiceDiscovery {
    int RunClient(int argc, const char** argv) {
        NLastGetopt::TOpts opts;

        TString data;

        opts.SetFreeArgsNum(2);
        opts.SetFreeArgTitle(0, "<address> <command>", "server address and command name");

        opts
            .AddLongOption("data", "data")
            .Optional()
            .RequiredArgument()
            .StoreResult(&data);

        NLastGetopt::TOptsParseResult parsedOpts(&opts, argc, argv);

        const TString address = parsedOpts.GetFreeArgs()[0];
        const TString command = to_lower(parsedOpts.GetFreeArgs()[1]);

        TClient client(address);
        auto router = CreateDiscoveryRouter(client);

        Cout << router->Handle(to_lower(command), data, {}).Content << Endl;

        return EXIT_SUCCESS;
    }

    TClient::TClient(const TStringBuf address, const TDuration timeout)
        : Channel_(grpc::CreateChannel(static_cast<std::string>(address), grpc::InsecureChannelCredentials()))
        , Stub_(NApi::TServiceDiscoveryService::NewStub(Channel_))
        , Timeout_(timeout)
    {
    }

    void TClient::ResolveEndpoints(NInfra::TRequestPtr<NApi::TReqResolveEndpoints> request, NInfra::TReplyPtr<NApi::TRspResolveEndpoints> reply) {
        GrpcRequest(request, reply, &NApi::TServiceDiscoveryService::Stub::ResolveEndpoints);
    }

    void TClient::ResolveNode(NInfra::TRequestPtr<NApi::TReqResolveNode> request, NInfra::TReplyPtr<NApi::TRspResolveNode> reply) {
        GrpcRequest(request, reply, &NApi::TServiceDiscoveryService::Stub::ResolveNode);
    }

    void TClient::ResolvePods(NInfra::TRequestPtr<NApi::TReqResolvePods> request, NInfra::TReplyPtr<NApi::TRspResolvePods> reply) {
        GrpcRequest(request, reply, &NApi::TServiceDiscoveryService::Stub::ResolvePods);
    }

    void TClient::Ping(NInfra::TRequestPtr<NApi::TReqPing> request, NInfra::TReplyPtr<NApi::TRspPing> reply) {
        GrpcRequest(request, reply, &NApi::TServiceDiscoveryService::Stub::Ping);
    }

}
