#pragma once

#include <infra/yp_service_discovery/api/api.grpc.pb.h>
#include <infra/yp_service_discovery/libs/service_iface/api.h>

#include <contrib/libs/grpc/include/grpc++/channel.h>
#include <contrib/libs/grpc/include/grpc++/create_channel.h>

#include <util/datetime/base.h>
#include <util/generic/strbuf.h>
#include <util/generic/yexception.h>

#include <chrono>

namespace NYP::NServiceDiscovery {
    int RunClient(int argc, const char** argv);

    class TClient: public IApi {
    public:
        TClient(const TStringBuf address, const TDuration timeout = TDuration::Seconds(1));

        void ResolveEndpoints(NInfra::TRequestPtr<NApi::TReqResolveEndpoints> request, NInfra::TReplyPtr<NApi::TRspResolveEndpoints> reply) override;

        void ResolveNode(NInfra::TRequestPtr<NApi::TReqResolveNode> request, NInfra::TReplyPtr<NApi::TRspResolveNode> reply) override;

        void ResolvePods(NInfra::TRequestPtr<NApi::TReqResolvePods> request, NInfra::TReplyPtr<NApi::TRspResolvePods> reply) override;

        void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) override;

    private:
        template <class TRequest, class TReply, class TCallback>
        void GrpcRequest(NInfra::TRequestPtr<TRequest> request, NInfra::TReplyPtr<TReply> reply, TCallback&& callback) {
            TReply result;

            grpc::ClientContext context;
            context.set_deadline(std::chrono::system_clock::now() + std::chrono::milliseconds(Timeout_.MilliSeconds()));

            if (grpc::Status status = ((*Stub_).*callback)(&context, request->Get(), &result); !status.ok()) {
                ythrow yexception() << TStringBuf("\nCode: ") << static_cast<ui64>(status.error_code()) << TStringBuf("\nMessage: ") << status.error_message();
            }

            reply->Set(result);
        }

    private:
        std::shared_ptr<grpc::Channel> Channel_;
        std::shared_ptr<NApi::TServiceDiscoveryService::Stub> Stub_;

        const TDuration Timeout_;
    };

}
