#include "server.h"

#include <util/datetime/base.h>

namespace NYP::NServiceDiscovery {
    TGrpcServer::TGrpcServer(const TGrpcServiceConfig& config, IService& service)
        : GrpcService_(service)
        , ServerAddress_("0.0.0.0:" + ToString(config.GetPort())) // https://st.yandex-team.ru/DTCC-695
    {
        if (config.HasMaxConnectionIdleTime()) {
            ServerBuilder_.AddChannelArgument(GRPC_ARG_MAX_CONNECTION_IDLE_MS, TDuration::Parse(config.GetMaxConnectionIdleTime()).MilliSeconds());
        }

        ServerBuilder_.AddListeningPort(ServerAddress_, grpc::InsecureServerCredentials());
        ServerBuilder_.RegisterService(&GrpcService_);
    }

    TGrpcServer::~TGrpcServer() {
        try {
            Stop();
        } catch (...) {
            // ¯\_(ツ)_/¯
        }
    }

    void TGrpcServer::Start(NInfra::TLogFramePtr logFrame) {
        Server_ = ServerBuilder_.BuildAndStart();
        logFrame->LogEvent(NInfra::NLogEvent::TStartService("grpc", ToString(ServerAddress_)));
    }

    void TGrpcServer::Wait(NInfra::TLogFramePtr logFrame) {
        {
            TGuard<TMutex> guard(Mutex_);

            while (!Shutdown_) {
                CondVar_.Wait(Mutex_);
            }
        }

        Stop();

        logFrame->LogEvent(NInfra::NLogEvent::TStopService("grpc"));
    }

    void TGrpcServer::Stop() {
        Server_->Shutdown();
        Server_->Wait();
    }

    void TGrpcServer::Shutdown() {
        TGuard<TMutex> guard(Mutex_);

        if (!Shutdown_) {
            Shutdown_ = true;

            CondVar_.Signal();
        }
    }

}
