#pragma once

#include "service.h"

#include <infra/yp_service_discovery/libs/config/config.pb.h>
#include <infra/yp_service_discovery/libs/service_iface/service_iface.h>

#include <infra/libs/logger/log_frame.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

#include <util/system/condvar.h>
#include <util/system/mutex.h>

#include <string>

namespace NYP::NServiceDiscovery {
    class TGrpcServer {
    public:
        TGrpcServer(const TGrpcServiceConfig& config, IService& service);
        ~TGrpcServer();

        void Start(NInfra::TLogFramePtr logFrame);

        void Stop();

        void Wait(NInfra::TLogFramePtr logFrame);

        void Shutdown();

    private:
        TGrpcService GrpcService_;
        TString ServerAddress_; // https://st.yandex-team.ru/DTCC-695
        grpc::ServerBuilder ServerBuilder_;
        std::unique_ptr<grpc::Server> Server_;

        TMutex Mutex_;
        TCondVar CondVar_;
        bool Shutdown_;
    };

}
