#include "service.h"

namespace NYP::NServiceDiscovery {
    TGrpcService::TGrpcService(IService& service)
        : Service_(service)
    {
    }

    using Status = grpc::Status;

    Status TGrpcService::ResolveEndpoints(ServerContext* ctx, const NApi::TReqResolveEndpoints* request, NApi::TRspResolveEndpoints* response) {
        return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.ResolveEndpoints(request, reply); });
    }

    Status TGrpcService::ResolveNode(ServerContext* ctx, const NApi::TReqResolveNode* request, NApi::TRspResolveNode* response) {
        return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.ResolveNode(request, reply); });
    }

    Status TGrpcService::ResolvePods(ServerContext* ctx, const NApi::TReqResolvePods* request, NApi::TRspResolvePods* response) {
        return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.ResolvePods(request, reply); });
    }
}
