#pragma once

#include <infra/yp_service_discovery/api/api.grpc.pb.h>
#include <infra/yp_service_discovery/libs/service_iface/protos/service.pb.h>
#include <infra/yp_service_discovery/libs/service_iface/service_iface.h>

#include <infra/libs/service_iface/str_iface.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

namespace NYP::NServiceDiscovery {
    class TGrpcService: public NApi::TServiceDiscoveryService::Service {
    public:
        using Status = grpc::Status;
        using ServerContext = grpc::ServerContext;

    public:
        TGrpcService(IService& service);

        Status ResolveEndpoints(ServerContext*, const NApi::TReqResolveEndpoints* request, NApi::TRspResolveEndpoints* response) override;

        Status ResolveNode(ServerContext*, const NApi::TReqResolveNode* request, NApi::TRspResolveNode* response) override;

        Status ResolvePods(ServerContext*, const NApi::TReqResolvePods* request, NApi::TRspResolvePods* response) override;

    private:
        template <class TRequest, class TReply, class TCallback>
        Status Call(ServerContext* ctx, const TRequest* request, TReply* reply, TCallback&& callback) {
            try {
                NInfra::TAttributes attributes;
                for (const auto& [key, value] : ctx->client_metadata()) {
                    attributes.insert({TString(key.data(), key.size()), TString(value.data(), value.size())});
                }
                attributes.emplace(NInfra::NServiceAttributes::RemoteAddressAttributeName(), ctx->peer());

                NInfra::TRequestPtr<TRequest> requestPtr(new NInfra::TProtoRequest<TRequest>(TStringBuf(), *request, attributes));
                NInfra::TAttributes responseAttributes;
                NInfra::TReplyPtr<TReply> replyPtr(new NInfra::TProtoReply<TReply>(*reply, responseAttributes));
                callback(requestPtr, replyPtr);
                return Status::OK;
            } catch (const NInfra::TAccessDeniedError& ex) {
                return Status(grpc::StatusCode::UNAUTHENTICATED, std::string(CurrentExceptionMessage().data()));
            } catch (const NInfra::TServiceError& ex) {
                return Status(ex.GetGrpcStatusCode(), std::string(CurrentExceptionMessage().data()));
            } catch (...) {
                return Status(grpc::StatusCode::INTERNAL, std::string(CurrentExceptionMessage().data()));
            }
        }

    private:
        IService& Service_;
    };

}
