#include "main.h"

#include <infra/yp_service_discovery/libs/config/config.pb.h>
#include <infra/yp_service_discovery/libs/service/service.h>

#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/proto_config/config.h>
#include <library/cpp/protobuf/json/proto2json.h>

namespace NYP::NServiceDiscovery {
    namespace {
        void PrettyPrintConfig(const TConfig& config) {
            NJson::TJsonValue configJson;
            TStringStream str{NProtobufJson::Proto2Json(config)};
            Cout << NJson::WriteJson(NJson::ReadJsonTree(&str, /* allowComments */ false, /* throwOnError */ true), /* formatOutput */ true) << Endl;
        }

        int RunMain(const TConfig& config) {
            PrettyPrintConfig(config);

            NInfra::SetSensorRegistryCommonGroup({"yp_service_discovery"});

            TService service(config);
            service.Start();
            service.Wait();
            return 0;
        }

    } // end of anonymous namespace

    int RunMain(NProtoConfig::TLoadConfigOptions& options) {
        const auto cfg = NProtoConfig::LoadWithOptions<TConfig>(options);
        return RunMain(cfg);
    }

    int RunMain(int argc, const char* argv[]) {
        const auto cfg = NProtoConfig::GetOpt<TConfig>(argc, argv, "/yp_service_discovery/proto_config.json");
        return RunMain(cfg);
    }

}
