#pragma once

#include "endpointset.h"

#include <util/folder/path.h>

namespace NYP::NServiceDiscovery {
    struct TStatEnv;

    struct TValidationOptions {
        bool AllowEmptyEndpointSetsOnStart = false;
        bool CheckForExistence = false;
    };

    class TEndpointSetCache : TNonCopyable {
    public:
        TEndpointSetCache(const TString& dir, const TEndpointSetKey& key, const TValidationOptions& validationOptions = {});

        bool Store(const NApi::TEndpointSet& endpoints, const TEndpointSetInfo& info);
        bool Store(const NApi::TEndpointSet& endpoints, const TEndpointSetInfo& info, TStatEnv& statEnv);
        void Load();

        const TEndpointSetEx& Get() const {
            return CurrentData_;
        }

        const TFsPath& GetEndpointSetDir() const {
            return DirPath_;
        }

        size_t GetCurrentVersion() const {
            return CurrentData_.Info.Version;
        }

        const TFsPath& GetCacheFile() const {
            return CacheFile_;
        }

        void SetLastApplied(const TEndpointSetEx& endpointset);

        static int DefaultFileMode();

    private:
        void CheckDir() {
            DirPath_.MkDir();
        }

        void StoreToFile(const NApi::TEndpointSet& endpoints, const TEndpointSetInfo& info, TStatEnv& statEnv);
        void LoadFromFile();
        void LoadFromMemory();

        void ReadFromFile(const TFsPath& path);
    private:
        const TEndpointSetKey Key_;

        const TFsPath DirPath_;
        const TFsPath CacheFile_;
        TFileStat FileStat_;

        TEndpointSetEx CurrentData_;
        TEndpointSetEx LastStored_;
        TEndpointSetEx LastApplied_;

        bool HasChanges_ = false;
        bool LastUpdateSucceeded_ = true;

        TValidationOptions ValidationOptions_;
    };

    void ValidateEndpointSet(const NApi::TEndpointSet& endpointSet, const TValidationOptions& options, const TEndpointSetInfo& currentInfo);
}
