#include "client.h"
#include "http_resolver.h"

namespace NYP::NServiceDiscovery {
    IRemoteRequesterPtr MakeRequester(const TSDConfig& config) {
        if (!config.GetHost()) {
            return nullptr;
        }

        return MakeAtomicShared<THttpResolver>(config, FromString<TDuration>(config.GetConnectTimeout()), FromString<TDuration>(config.GetRequestTimeout()));
    }

    TSDClientImpl::TSDClientImpl(const TSDConfig& config, bool externalLog)
        : RequesterPtr(MakeRequester(config))
        , Log(CreateLogBackend(externalLog ? "" : config.GetLog()))
    {
    }
}
