#pragma once

#include <infra/yp_service_discovery/libs/sdlib/config/config.h>

#include "manager.h"

namespace NYP::NServiceDiscovery {
    struct TSDClientImpl {
    public:
        explicit TSDClientImpl(const TSDConfig& config, bool externalLog);
    public:
        IRemoteRequesterPtr RequesterPtr;
        TLog Log;
    };

    class TSDClient
        : TSDClientImpl
        , public TEndpointSetManager
    {
    public:
        explicit TSDClient(const TSDConfig& config, TCounterFactory f = StandaloneCounterFactory, bool externalLog = false)
            : TSDClientImpl(config, externalLog)
            , TEndpointSetManager(config, RequesterPtr, f)
            , ExternalLog_(externalLog)
            , UpdateFrequency_(FromString<TDuration>(config.GetUpdateFrequency()))
        {
            if (!ExternalLog_) {
                AssignLog(&Log);
            }
        }

        TSDClient(const TSDConfig&, std::function<THolder<IStatCounterImpl>(const TString&)>, bool = false) = delete;

        virtual ~TSDClient() {}

        void Start(TUpdateCallback updateCallback = {}) {
            TEndpointSetManager::Start(UpdateFrequency_, TUpdateMode(), updateCallback);
        }

        void ReopenLog() {
            if (!ExternalLog_) {
                Log.ReopenLog();
            }
        }
    private:
        const bool ExternalLog_;
        const TDuration UpdateFrequency_;
    };
}
