#pragma once

#include <infra/yp_service_discovery/libs/sdlib/endpointset.pb.h>

#include <util/digest/multi.h>
#include <util/generic/algorithm.h>

namespace NYP::NServiceDiscovery {

    struct TEndpointSetInfo
        : public TEndpointSetProtoInfo
    {
        size_t Version = 0;
    };

    struct TEndpointSetEx
        : public NApi::TEndpointSet
    {
    public:
        TEndpointSetEx() = default;
        TEndpointSetEx(const NApi::TEndpointSet& endpointSet, const TEndpointSetInfo& info)
            : NApi::TEndpointSet(endpointSet)
            , Info(info)
        {
        }

        TEndpointSetInfo Info;
    };

    void ReadFile(const TString& filename, NApi::TEndpointSet& endpointSet, TEndpointSetInfo& info);
    void SortEndpointSet(NApi::TEndpointSet* es);
    bool IsOnlyReadinessChanged(const NApi::TEndpointSet& prev, const NApi::TEndpointSet& next);
    bool EndpointsEqualExceptReady(const NApi::TEndpoint& a, const NApi::TEndpoint& b);

    inline void ReadFile(const TString& filename, NApi::TEndpointSet& endpointSet) {
        TEndpointSetInfo unused;
        ReadFile(filename, endpointSet, unused);
    }

    void WriteFile(const TString& filename, const NApi::TEndpointSet& endpointSet, const TEndpointSetInfo& info);

    class TEndpointSetKey
        : public NApi::TReqResolveEndpoints {
    public:
        const TString FilePath;

    public:
        TEndpointSetKey(const TString& cluster, const TString& id) {
            set_cluster_name(cluster);
            set_endpoint_set_id(id);
        }

        TEndpointSetKey(const TString& filepath)
            : FilePath(filepath)
        {
        }

        TString ToString() const;

        struct THash {
            size_t operator()(const TEndpointSetKey& key) {
                return MultiHash(key.cluster_name(), key.endpoint_set_id(), key.FilePath);
            }
        };

        struct TEqual {
            size_t operator()(const TEndpointSetKey& lhs, const TEndpointSetKey& rhs) {
                return lhs.cluster_name() == rhs.cluster_name() && lhs.endpoint_set_id() == rhs.endpoint_set_id() && lhs.FilePath == rhs.FilePath;
            }
        };
    };

    TString EndpointSetDirName(const TEndpointSetKey& key);

}
