#include "grpc_resolver.h"

#include <contrib/libs/grpc/include/grpc++/create_channel.h>

#include <util/draft/ip.h>
#include <util/string/builder.h>

namespace NYP::NServiceDiscovery {
    TGrpcResolver::TGrpcResolver(const TResolverAddress& address, const TDuration timeout)
        : Address_(address)
        , Timeout_(timeout)
    {
    }

    void TGrpcResolver::DoInit() {
        if (Channel_ && Stub_) {
            return;
        }

        TString host;
        if (Address_.CachedIp) {
            if (TryParseIp6FromString(Address_.CachedIp.c_str())) {
                host = TStringBuilder() << "[" << Address_.CachedIp << "]";
            } else {
                host = Address_.CachedIp;
            }
        } else {
            host = Address_.Host;
        }

        TString channelAddress = (TStringBuilder() << host << ":" << Address_.Port); // https://st.yandex-team.ru/DTCC-695

        Channel_ = grpc::CreateChannel(channelAddress, grpc::InsecureChannelCredentials());
        Y_ENSURE(Channel_);
        Stub_ = NApi::TServiceDiscoveryService::NewStub(Channel_);
        Y_ENSURE(Stub_);
    }

    void TGrpcResolver::DoResolve(const TResolveRequestBatch& request, TResolveResultBatch& result, TStatEnv& statEnv) {
        result.resize(request.size());

        for (size_t i = 0; i < request.size(); ++i) {
            grpc::ClientContext context;
            context.set_deadline(std::chrono::system_clock::now() + std::chrono::milliseconds(Timeout_.MilliSeconds()));

            if (auto* stat = statEnv.CommonStat) {
                ++stat->RemoteRequestsCounter;
            }

            grpc::Status s = Stub_->ResolveEndpoints(&context, request[i], &result[i].Result);
            if (!s.ok()) {
                result[i].ErrorMessage = s.error_message();
                result[i].HasError = true;
            }
        }
    }
}
