#pragma once

#include <infra/yp_service_discovery/libs/sdlib/resolver.h>
#include <contrib/libs/grpc/include/grpc++/channel.h>

namespace NYP::NServiceDiscovery {
    class TGrpcResolver
        : public IRemoteRequester {
    public:
        TGrpcResolver(const TResolverAddress& address, const TDuration timeout = TDuration::Seconds(1));

        void DoInit() override;

        void DoResolve(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&) override;
    private:
        std::shared_ptr<grpc::Channel> Channel_;
        std::shared_ptr<NApi::TServiceDiscoveryService::Stub> Stub_;

        const TResolverAddress Address_;
        const TDuration Timeout_;
    };
}
