#pragma once

#include "resolver.h"

namespace NYP::NServiceDiscovery {
    class THttpResolver
        : public IRemoteRequester
    {
    public:
        THttpResolver() = default;

        THttpResolver(const TResolverAddress& address, const TDuration connectTimeout, const TDuration requestTimeout)
            : Address_(address)
            , ConnectTimeout_(connectTimeout)
            , RequestTimeout_(requestTimeout)
        {
        }

        void DoInit() override {
            if (NetworkAddress_) {
                return;
            }

            if (Address_.CachedIp) {
                NetworkAddress_ = MakeHolder<TNetworkAddress>(Address_.CachedIp, Address_.Port);
            } else {
                NetworkAddress_ = MakeHolder<TNetworkAddress>(Address_.Host, Address_.Port);
            }
        }

        void DoResolve(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&) override;

        void ResolveOne(const NApi::TReqResolveEndpoints& request, NApi::TRspResolveEndpoints& result);
    private:
        THolder<TNetworkAddress> NetworkAddress_;

        const TResolverAddress Address_;
        const TDuration ConnectTimeout_;
        const TDuration RequestTimeout_;
    };
}
