#include "resolver.h"

namespace NYP::NServiceDiscovery {
    IRemoteRequesterPtr MakeRequester(std::function<void(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&)> requester, std::function<void()> initer, TDuration retryDelay) {
        class TRequester
            : public IRemoteRequester
        {
        public:
            TRequester(std::function<void(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&)> requester, std::function<void()> initer, TDuration retryDelay)
                : IRemoteRequester(retryDelay)
                , R_(requester)
                , I_(initer)
            {
            }

            void DoInit() override {
                if (I_) {
                    I_();
                }
            }

            void DoResolve(const TResolveRequestBatch& request, TResolveResultBatch& result, TStatEnv& stat) override {
                return R_(request, result, stat);
            }
        private:
            std::function<void(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&)> R_;
            std::function<void()> I_;
        };

        return MakeAtomicShared<TRequester>(requester, initer, retryDelay);
    }
}
