#pragma once

#include "manager.h"

#include <infra/yp_service_discovery/api/api.grpc.pb.h>

#include <util/network/address.h>

namespace NYP::NServiceDiscovery {
    struct TResolverAddress {
    public:
        TResolverAddress(const TSDConfigProto& config)
            : Host(config.GetHost())
            , CachedIp(config.GetCachedIp())
            , Port(config.GetPort())
        {
        }

        TResolverAddress(const TString& host, ui32 port)
            : Host(host)
            , Port(port)
        {
        }
    public:
        TString Host;
        TString CachedIp;
        ui32 Port = 0;
    };

    IRemoteRequesterPtr MakeRequester(std::function<void(const TResolveRequestBatch&, TResolveResultBatch&, TStatEnv&)> requester, std::function<void()> initer = {}, TDuration retryDelay = {});
}
